# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 7
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR7_strategy.txt
# LLM Suggested Fallback: D

def benevolent_trust_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    # Early phase: build trust with consistent cooperation
    if current_round <= 3:
        return "C"
    # Mid-game: strategic defection to test opponent's response
    elif current_round == 4:
        return "D"
    elif current_round == 5:
        return "C"  # Feign reconciliation to confuse opponent
    elif current_round == 6:
        return "D"  # Capitalize on opponent's potential cooperation
    elif current_round == 7:
        return "C"  # Maintain illusion of unpredictability
    # Late-game: maximize payoff by defecting consistently
    else:
        return "D"